import type { SVGProps } from 'react';

interface CustomIconProps extends SVGProps<SVGSVGElement> {
    size?: number;
    fill?: string;
    stroke?: string;
    strokeWidth?: number;
    viewBox?: string;
}

const migrate = ({
    size = 24,
    fill = 'none',
    stroke = 'none',
    strokeWidth = 1,
    viewBox = '0 0 24 24',
    ...props
} : CustomIconProps) :JSX.Element => (
    <svg
        width={size}
        height={size}
        viewBox={viewBox}
        fill={fill}
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path d="M5.8248 17L7.7248 18.9C7.9248 19.1 8.02064 19.3333 8.0123 19.6C8.00397 19.8667 7.8998 20.1 7.6998 20.3C7.4998 20.4833 7.26647 20.5792 6.9998 20.5875C6.73314 20.5958 6.4998 20.5 6.2998 20.3L2.6998 16.7C2.5998 16.6 2.52897 16.4917 2.4873 16.375C2.44564 16.2583 2.4248 16.1333 2.4248 16C2.4248 15.8667 2.44564 15.7417 2.4873 15.625C2.52897 15.5083 2.5998 15.4 2.6998 15.3L6.2998 11.7C6.48314 11.5167 6.7123 11.425 6.9873 11.425C7.2623 11.425 7.4998 11.5167 7.6998 11.7C7.8998 11.9 7.9998 12.1375 7.9998 12.4125C7.9998 12.6875 7.8998 12.925 7.6998 13.125L5.8248 15H19.9998C20.2831 15 20.5206 15.0958 20.7123 15.2875C20.904 15.4792 20.9998 15.7167 20.9998 16C20.9998 16.2833 20.904 16.5208 20.7123 16.7125C20.5206 16.9042 20.2831 17 19.9998 17H5.8248ZM18.1748 8.99999H3.9998C3.71647 8.99999 3.47897 8.90415 3.2873 8.71249C3.09564 8.52082 2.9998 8.28332 2.9998 7.99999C2.9998 7.71665 3.09564 7.47915 3.2873 7.28749C3.47897 7.09582 3.71647 6.99999 3.9998 6.99999H18.1748L16.2748 5.09999C16.0748 4.89999 15.979 4.66665 15.9873 4.39999C15.9956 4.13332 16.0998 3.89999 16.2998 3.69999C16.4998 3.51665 16.7331 3.42082 16.9998 3.41249C17.2665 3.40415 17.4998 3.49999 17.6998 3.69999L21.2998 7.29999C21.3998 7.39999 21.4706 7.50832 21.5123 7.62499C21.554 7.74165 21.5748 7.86665 21.5748 7.99999C21.5748 8.13332 21.554 8.25832 21.5123 8.37499C21.4706 8.49165 21.3998 8.59999 21.2998 8.69999L17.6998 12.3C17.5165 12.4833 17.2873 12.575 17.0123 12.575C16.7373 12.575 16.4998 12.4833 16.2998 12.3C16.0998 12.1 15.9998 11.8625 15.9998 11.5875C15.9998 11.3125 16.0998 11.075 16.2998 10.875L18.1748 8.99999Z" fill="currentColor"/>
    </svg>
);

export default migrate;