<?php
/**
 * Sitemap settings page
 *
 * @package XML Sitemap & Google News
 */

?>
<style type="text/css">
<?php require XMLSF_DIR . '/assets/admin.css'; ?>
</style>
<div class="wrap">

	<h1><?php esc_html_e( 'XML Sitemap', 'xml-sitemap-feed' ); ?></h1>

	<p>
		<?php printf( /* translators: Plugin name */ esc_html__( 'These settings control the XML Sitemaps generated by the %s plugin.', 'xml-sitemap-feed' ), esc_html__( 'XML Sitemap & Google News', 'xml-sitemap-feed' ) ); ?>
	</p>

	<nav class="nav-tab-wrapper">
		<a class="nav-tab<?php echo 'general' === $active_tab ? ' nav-tab-active' : '" href="?page=xmlsf&tab=general'; ?>"><?php echo esc_html( translate( 'General' ) ); // phpcs:ignore WordPress.WP.I18n.LowLevelTranslationFunction ?></a>
		<a class="nav-tab<?php echo 'post_types' === $active_tab ? ' nav-tab-active' : '" href="?page=xmlsf&tab=post_types'; ?>"><?php esc_attr_e( 'Post types', 'xml-sitemap-feed' ); ?></a>
		<?php
		if ( empty( $disabled ) || ! in_array( 'taxonomies', (array) $disabled, true ) ) {
			?>
		<a class="nav-tab<?php echo 'taxonomies' === $active_tab ? ' nav-tab-active' : '" href="?page=xmlsf&tab=taxonomies'; ?>"><?php esc_attr_e( 'Taxonomies', 'xml-sitemap-feed' ); ?></a>
			<?php
		}
		if ( empty( $disabled ) || ! in_array( 'users', (array) $disabled, true ) ) {
			?>
		<a class="nav-tab<?php echo 'authors' === $active_tab ? ' nav-tab-active' : '" href="?page=xmlsf&tab=authors'; ?>"><?php esc_attr_e( 'Authors', 'xml-sitemap-feed' ); ?></a>
			<?php
		}
		?>
		<a class="nav-tab<?php echo 'advanced' === $active_tab ? ' nav-tab-active' : '" href="?page=xmlsf&tab=advanced'; ?>"><?php echo esc_html( translate( 'Advanced' ) ); // phpcs:ignore WordPress.WP.I18n.LowLevelTranslationFunction ?></a>
		<?php do_action( 'xmlsf_sitemap_nav_tabs', $active_tab ); ?>
	</nav>

	<div class="main">
		<form id="xmlsf-settings-form" method="post" action="options.php">

			<?php do_action( 'xmlsf_settings_before', $active_tab ); ?>

			<?php settings_fields( 'xmlsf_' . $active_tab ); ?>

			<?php do_settings_sections( 'xmlsf_' . $active_tab ); ?>

			<?php do_action( 'xmlsf_settings_after', $active_tab ); ?>

			<?php submit_button(); ?>

		</form>
	</div>

	<div class="sidebar">
		<?php
		if ( ! \XMLSF\Admin\Sitemap::compatible_with_advanced() ) {
			echo '<div style="background:rgb(252, 229, 231); margin-left: -14px; padding: 5px 10px; border: 4px solid rgb(214, 73, 54); border-radius: 3px; margin-bottom: 20px; font-weight: bold;">';
			include XMLSF_DIR . '/views/admin/section-advanced-compat-message.php';
			echo '</div>';
		}
		?>

		<h3><span class="dashicons dashicons-welcome-view-site"></span> <?php echo esc_html( translate( 'View' ) ); // phpcs:ignore WordPress.WP.I18n.LowLevelTranslationFunction ?></h3>
		<p>
			<?php
			printf(
				/* translators: Sitemap name with URL */
				esc_html__( 'Open your %s', 'xml-sitemap-feed' ),
				'<strong><a href="' . esc_attr( $sitemap_url ) . '" target="_blank">' . esc_html__( 'XML Sitemap Index', 'xml-sitemap-feed' ) . '</a></strong><span class="dashicons dashicons-external"></span>'
			);
			?>
		</p>

		<?php do_action( 'xmlsf_admin_sidebar' ); ?>

	</div>

</div>
<script>
<?php require XMLSF_DIR . '/assets/admin.js'; ?>
</script>
